/* vi: set sw=4 ts=4: */
/*
 * setuid() for uClibc
 *
 * Copyright (C) 2000-2006 Erik Andersen <andersen@uclibc.org>
 *
 * Licensed under the LGPL v2.1, see the file COPYING.LIB in this tarball.
 */

#include <sys/syscall.h>
#include <unistd.h>
#include <bits/wordsize.h>
#include <setxid.h>

int setuid(uid_t uid)
{
	int result;
#if (__WORDSIZE == 32 && defined(__NR_setuid32)) || __WORDSIZE == 64
# ifdef __NR_setuid32
#  undef __NR_setuid
#  define __NR_setuid __NR_setuid32
# endif

#else

	if (uid == (uid_t) ~ 0 || uid != (uid_t) ((__kernel_uid_t) uid)) {
		__set_errno(EINVAL);
		return -1;
	}
#endif
	result = INLINE_SETXID_SYSCALL (setuid, 1, uid);
	return result;
}
