/*
 * Copyright (c) 2011  STMicroelectronics Ltd
 * Author: Filippo Arcidiacono (filippo.arcidiacono@st.com)
 *
 * Licensed under the LGPL v2.1, see the file COPYING.LIB in this tarball.
 *
 * Based on glibc code.
 * __printf_fp implemented from scratch.
 *
 */

/* FIXME */
#ifdef __CHAR_UNSIGNED__
#warning __CHAR_UNSIGNED__ defined! UNDEF now.
#undef __CHAR_UNSIGNED__
#endif

#include <ctype.h>
#include <errno.h>
#include <langinfo.h>
#include <locale.h>
#include <monetary.h>
#include <printf.h>
#include <stdarg.h>
#include <stdio.h>
#include <string.h>


#define out_char(Ch)							      \
  do {									      \
    if (dest >= s + maxsize - 1)					      \
      {									      \
	__set_errno (E2BIG);						      \
	va_end (ap);							      \
	return -1;							      \
      }									      \
    *dest++ = (Ch);							      \
  } while (0)

#define out_string(String)						      \
  do {									      \
    const char *_s = (String);						      \
    while (*_s)								      \
      out_char (*_s++);							      \
  } while (0)

#define out_nstring(String, N)						      \
  do {									      \
    int _n = (N);							      \
    const char *_s = (String);						      \
    while (_n-- > 0)							      \
      out_char (*_s++);							      \
  } while (0)

#define copy_string(Dest, Src)				\
  while (*(Src) != '\0')				\
	*(Dest)++ = *(Src)++;


#define to_digit(Ch) ((Ch) - '0')

/* Return the number of extra grouping characters that will be inserted
   into a number with INTDIG_MAX integer digits.  */

static unsigned int
__guess_grouping (unsigned int intdig_max, const char *grouping)
{
	unsigned int groups;

	/* We treat all negative values like CHAR_MAX.  */

	if (*grouping == CHAR_MAX || *grouping <= 0)
	/* No grouping should be done.  */
		return 0;

	groups = 0;
	while (intdig_max > (unsigned int) *grouping)
	{
		++groups;
		intdig_max -= *grouping++;

		if (*grouping == CHAR_MAX
#if CHAR_MIN < 0
		|| *grouping < 0
#endif
		)
			/* No more grouping should be done.  */
			break;
		else if (*grouping == 0)
		{
			/* Same grouping repeats.  */
			groups += (intdig_max - 1) / grouping[-1];
			break;
		}
	}

	return groups;
}

/* The floating-point value to output.  */
typedef union
{
	double dbl;
	__long_double_t ldbl;
} float_type_t;

static int __printf_fp(char *str, struct printf_info *fpinfo,
			float_type_t number, int extra_char)
{
	char string_fmt[20];
	char st[10];
	char out_str[50];
	char *first, *first_digit, *pstring_fmt, *pst, *pstr;
	int res, ndigits, ngroup, msdigits, nsep;
	/* Locale-dependent thousands separator and grouping specification */
	const char *thousands_sep = NULL;
	const char *grouping;


	first = str;
	ndigits = ngroup = msdigits = 0;
	memset(string_fmt, '\0', sizeof(string_fmt));
	pstring_fmt = string_fmt;
	pst = st;
	*pstring_fmt++ = '%';

	sprintf(st, "%d", fpinfo->width);
	copy_string(pstring_fmt, pst);
	*pstring_fmt++ = '.';
	sprintf(st, "%d", fpinfo->prec);
	pst = st;

	copy_string(pstring_fmt, pst);

	if (PRINT_INFO_FLAG_VAL(fpinfo, is_long_double))
		*pstring_fmt++ = 'L';
	else
		*pstring_fmt++ = 'f';
	*pstring_fmt = '\0';
	if (PRINT_INFO_FLAG_VAL(fpinfo, is_long_double))
		res = sprintf (out_str, string_fmt, number.ldbl);
	else
		res = sprintf (out_str, string_fmt, number.dbl);

	pst = out_str;
	pstr = str;
	while(*pst == ' ') /* Skip initial blank space. */
		*pstr++ = *pst++;
	if (PRINT_INFO_FLAG_VAL(fpinfo, group)) {
		grouping = nl_langinfo(MON_GROUPING);
		if (*grouping <= 0 || *grouping == CHAR_MAX)
			grouping = NULL;
		else
			thousands_sep = nl_langinfo(MON_THOUSANDS_SEP);
	} else
		grouping = NULL;

	nsep = 0;
	if (grouping) {
		first_digit = pst;
		while(isdigit(*pst)) {
			pst++;
			ndigits++;
		}
		ngroup = ndigits / 3;
		msdigits = ndigits - (ngroup * 3);
		pst = first_digit;
		if (msdigits && ngroup) {
			while (msdigits--)
				*pstr++ = *pst++;
			*pstr++ = *thousands_sep;
			nsep++;
		}
		while (ngroup--) {
			*pstr++ = *pst++;
			*pstr++ = *pst++;
			*pstr++ = *pst++;
			if (ngroup) {
				*pstr++ = *thousands_sep;
				nsep++;
			}
		}
	}

	*pstr = '\0';
	if (nsep && extra_char) {
		while (nsep--) {
			pstr = str;
			while(*++pstr != '\0')
				*(pstr - 1) = *pstr;
			*pstr = '\0';
		}
		pstr--;
	} else
		res += nsep;

	copy_string(pstr, pst);
	*pstr = '\0';

	if (fpinfo->pad != ' ')
		while(!isdigit(*first))
			*first++ = fpinfo->pad;

	return res;
}

static const char utf8[] = "UTF-8";
static const char ascii[] = "ASCII";

#ifndef __LOCALE_C_ONLY
/* get locale utility functions. */
#include <find_locale.c>

static void get_locale(char *loc_name, int cat)
{
	locale_entry *locales;
	int row;            /* locale row */
	unsigned char *cur_loc = __global_locale->cur_locale + 1;

	cur_loc += (cat * 2);
	row = (((int) (*cur_loc & 0x7f)) << 7) + (cur_loc[1] & 0x7f);
	locales = GET_LOCALE_ENTRY(row);
	find_locale_string(locales, loc_name);

}
#endif

/* We have to overcome some problems with this implementation.  On the
   one hand the strfmon() function is specified in XPG4 and of course
   it has to follow this.  But on the other hand POSIX.2 specifies
   some information in the LC_MONETARY category which should be used,
   too.  Some of the information contradicts the information which can
   be specified in format string.  */

static ssize_t
__vstrfmon_l (char *s, size_t maxsize __LOCALE_PARAM, const char *format,
	      va_list ap)
{
  char *dest;			/* Pointer so copy the output.  */
  const char *fmt;		/* Pointer that walks through format.  */
  dest = s;
  fmt = format;

#ifndef __LOCALE_C_ONLY
  char mon_locale[40];
  char num_locale[40];
  char *ls;

/*
 * FIXME: Setting LC_NUMERIC locale to the LC_MONETARY one to allow
 *        sprintf correctly display decimal point separator.
 *        It will be restored before to exit from strfmon function.
 */
  get_locale(mon_locale, __LC_MONETARY);
  get_locale(num_locale, __LC_NUMERIC);
  ls = setlocale(LC_NUMERIC, mon_locale);
  if (ls == NULL) {
     fprintf (stderr, "setlocale(LC_NUMERIC, \"%s\"): %m\n", mon_locale);
     return (1);
  }
#endif

  /* Loop through the format-string.  */
  while (*fmt != '\0')
    {
      float_type_t fpnum;
      struct printf_info info;
      int int_format;
      int print_curr_symbol;
      int left_prec;
      int left_pad;
      int right_prec;
      int group;
      char pad;
      int is_long_double;
      int p_sign_posn;
      int n_sign_posn;
      int sign_posn;
      int other_sign_posn;
      int left;
      int is_negative;
      int sep_by_space;
      int other_sep_by_space;
      int cs_precedes;
      int other_cs_precedes;
      const char *sign_string;
      const char *other_sign_string;
      int done;
      const char *currency_symbol;
      size_t currency_symbol_len;
      long int width;
      char *startp;
      const void *ptr;
      char space_char;
      int extra_char = 0;

      /* Process all character which do not introduce a format
	 specification.  */
      if (*fmt != '%')
	{
	  out_char (*fmt++);
	  continue;
	}

      /* "%%" means a single '%' character.  */
      if (fmt[1] == '%')
	{
	  out_char (*++fmt);
	  ++fmt;
	  continue;
	}

      /* Defaults for formatting.  */
      int_format = 0;			/* Use international curr. symbol */
      print_curr_symbol = 1;		/* Print the currency symbol.  */
      left_prec = -1;			/* No left precision specified.  */
      right_prec = -1;			/* No right precision specified.  */
      group = 1;			/* Print digits grouped.  */
      pad = ' ';			/* Fill character is <SP>.  */
      is_long_double = 0;		/* Double argument by default.  */
      p_sign_posn = -1;			/* This indicates whether the */
      n_sign_posn = -1;			/* '(' flag is given.  */
      width = -1;			/* No width specified so far.  */
      left = 0;				/* Right justified by default.  */

      /* Parse group characters.  */
      while (1)
	{
	  switch (*++fmt)
	    {
	    case '=':			/* Set fill character.  */
	      pad = *++fmt;
	      if (pad == '\0')
		{
		  /* Premature EOS.  */
		  __set_errno (EINVAL);
		  return -1;
		}
	      continue;
	    case '^':			/* Don't group digits.  */
	      group = 0;
	      continue;
	    case '+':			/* Use +/- for sign of number.  */
	      if (n_sign_posn != -1)
		{
		  __set_errno (EINVAL);
		  return -1;
		}
	      p_sign_posn = *nl_langinfo(P_SIGN_POSN);
	      n_sign_posn = *nl_langinfo(N_SIGN_POSN);
	      continue;
	    case '(':			/* Use ( ) for negative sign.  */
	      if (n_sign_posn != -1)
		{
		  __set_errno (EINVAL);
		  return -1;
		}
	      p_sign_posn = 0;
	      n_sign_posn = 0;
	      continue;
	    case '!':			/* Don't print the currency symbol.  */
	      print_curr_symbol = 0;
	      continue;
	    case '-':			/* Print left justified.  */
	      left = 1;
	      continue;
	    default:
	      /* Will stop the loop.  */;
	    }
	  break;
	}

      if (isdigit (*fmt))
	{
	  /* Parse field width.  */
	  width = to_digit (*fmt);

	  while (isdigit (*++fmt))
	    {
	      int val = to_digit (*fmt);

	      if (width > LONG_MAX / 10
		  || (width == LONG_MAX && val > LONG_MAX % 10))
		{
		  __set_errno (E2BIG);
		  return -1;
		}

	      width = width * 10 + val;
	    }

	  /* If we don't have enough room for the demanded width we
	     can stop now and return an error.  */
	  if (width >= maxsize - (dest - s))
	    {
	      __set_errno (E2BIG);
	      return -1;
	    }
	}

      /* Recognize left precision.  */
      if (*fmt == '#')
	{
	  if (!isdigit (*++fmt))
	    {
	      __set_errno (EINVAL);
	      return -1;
	    }
	  left_prec = to_digit (*fmt);

	  while (isdigit (*++fmt))
	    {
	      left_prec *= 10;
	      left_prec += to_digit (*fmt);
	    }
	}

      /* Recognize right precision.  */
      if (*fmt == '.')
	{
	  if (!isdigit (*++fmt))
	    {
	      __set_errno (EINVAL);
	      return -1;
	    }
	  right_prec = to_digit (*fmt);

	  while (isdigit (*++fmt))
	    {
	      right_prec *= 10;
	      right_prec += to_digit (*fmt);
	    }
	}

      /* Handle modifier.  This is an extension.  */
      if (*fmt == 'L')
	{
	  ++fmt;
	    is_long_double = 1;
	}

      /* Handle format specifier.  */
      char int_symbol[4];
      switch (*fmt++)
	{
	case 'i': {		/* Use international currency symbol.  */
	  const char *int_curr_symbol;

	  int_curr_symbol = nl_langinfo(INT_CURR_SYMBOL);
	  strncpy(int_symbol, int_curr_symbol, 3);
	  int_symbol[3] = '\0';

	  currency_symbol_len = 3;
	  currency_symbol = &int_symbol[0];
	  space_char = int_curr_symbol[3];
	  int_format = 1;
	  break;
	}
	case 'n':		/* Use national currency symbol.  */
	  currency_symbol = nl_langinfo(CURRENCY_SYMBOL);
	  currency_symbol_len = strlen (currency_symbol);
	  space_char = ' ';
	  int_format = 0;
	  break;
	default:		/* Any unrecognized format is an error.  */
	  __set_errno (EINVAL);
	  return -1;
	}

      /* If not specified by the format string now find the values for
	 the format specification.  */
      if (p_sign_posn == -1)
	p_sign_posn = int_format ? *nl_langinfo(INT_P_SIGN_POSN) :
					*nl_langinfo(P_SIGN_POSN);
      if (n_sign_posn == -1)
	n_sign_posn = int_format ? *nl_langinfo(INT_N_SIGN_POSN) :
					*nl_langinfo(N_SIGN_POSN);

      if (right_prec == -1)
	{
	right_prec = int_format ? *nl_langinfo(INT_FRAC_DIGITS) :
					*nl_langinfo(FRAC_DIGITS);

	  if (right_prec == CHAR_MAX)
	    right_prec = 2;
	}

      /* If we have to print the digits grouped determine how many
	 extra characters this means.  */
      if (group && left_prec != -1)
	extra_char = __guess_grouping (left_prec, nl_langinfo(MON_GROUPING));
      left_prec += extra_char;

      /* Now it's time to get the value.  */
      if (is_long_double == 1)
	{
	  fpnum.ldbl = va_arg (ap, long double);
	  is_negative = fpnum.ldbl < 0;
	  if (is_negative)
	    fpnum.ldbl = -fpnum.ldbl;
	}
      else
	{
	  fpnum.dbl = va_arg (ap, double);
	  is_negative = fpnum.dbl < 0;
	  if (is_negative)
	    fpnum.dbl = -fpnum.dbl;
	}

      /* We now know the sign of the value and can determine the format.  */
      if (is_negative)
	{
	  sign_string = nl_langinfo(NEGATIVE_SIGN);
	  /* If the locale does not specify a character for the
	     negative sign we use a '-'.  */
	  if (*sign_string == '\0')
	    sign_string = (const char *) "-";
	  cs_precedes = int_format ? *nl_langinfo(INT_N_CS_PRECEDES) : *nl_langinfo(N_CS_PRECEDES);
	  sep_by_space = int_format ? *nl_langinfo(INT_N_SEP_BY_SPACE) : *nl_langinfo(N_SEP_BY_SPACE);
	  sign_posn = n_sign_posn;

	  other_sign_string = nl_langinfo(POSITIVE_SIGN);
	  other_cs_precedes = int_format ? *nl_langinfo(INT_P_CS_PRECEDES) : *nl_langinfo(P_CS_PRECEDES);
	  other_sep_by_space = int_format ? *nl_langinfo(INT_P_SEP_BY_SPACE) : *nl_langinfo(P_SEP_BY_SPACE);
	  other_sign_posn = p_sign_posn;
	}
      else
	{
	  sign_string = nl_langinfo(POSITIVE_SIGN);
	  cs_precedes = int_format ? *nl_langinfo(INT_P_CS_PRECEDES) : *nl_langinfo(P_CS_PRECEDES);
	  sep_by_space = int_format ? *nl_langinfo(INT_P_SEP_BY_SPACE) : *nl_langinfo(P_SEP_BY_SPACE);
	  sign_posn = p_sign_posn;

	  other_sign_string = nl_langinfo(NEGATIVE_SIGN);
	  if (*other_sign_string == '\0')
	    other_sign_string = (const char *) "-";
	  other_cs_precedes = int_format ? *nl_langinfo(INT_N_CS_PRECEDES) : *nl_langinfo(N_CS_PRECEDES);
	  other_sep_by_space = int_format ? *nl_langinfo(INT_N_SEP_BY_SPACE) : *nl_langinfo(N_SEP_BY_SPACE);
	  other_sign_posn = n_sign_posn;
	}

      /* Set default values for unspecified information.  */
      if (cs_precedes != 0)
	cs_precedes = 1;
      if (other_cs_precedes != 0)
	other_cs_precedes = 1;
      if (sep_by_space == CHAR_MAX)
	sep_by_space = 0;
      if (other_sep_by_space == CHAR_MAX)
	other_sep_by_space = 0;
      if (sign_posn == CHAR_MAX)
	sign_posn = 1;
      if (other_sign_posn == CHAR_MAX)
	other_sign_posn = 1;

      /* Check for degenerate cases */
      if (sep_by_space == 2)
	{
	  if (sign_posn == 0 ||
	      (sign_posn == 1 && !cs_precedes) ||
	      (sign_posn == 2 && cs_precedes))
	    /* sign and symbol are not adjacent, so no separator */
	    sep_by_space = 0;
	}
      if (other_sep_by_space == 2)
	{
	  if (other_sign_posn == 0 ||
	      (other_sign_posn == 1 && !other_cs_precedes) ||
	      (other_sign_posn == 2 && other_cs_precedes))
	    /* sign and symbol are not adjacent, so no separator */
	    other_sep_by_space = 0;
	}

      /* Set the left precision and padding needed for alignment */
      if (left_prec == -1)
	{
	  left_prec = 0;
	  left_pad = 0;
	}
      else
	{
	  /* Set left_pad to number of spaces needed to align positive
	     and negative formats */

	  int left_bytes = 0;
	  int other_left_bytes = 0;

	  /* Work out number of bytes for currency string and separator
	     preceding the value */
	  if (cs_precedes)
	    {
	      left_bytes += currency_symbol_len;
	      if (sep_by_space != 0)
		++left_bytes;
	    }

	  if (other_cs_precedes)
	    {
	      other_left_bytes += currency_symbol_len;
	      if (other_sep_by_space != 0)
		++other_left_bytes;
	    }

	  /* Work out number of bytes for the sign (or left parenthesis)
	     preceding the value */
	  if (sign_posn == 0 && is_negative)
	    ++left_bytes;
	  else if (sign_posn == 1)
	    left_bytes += strlen (sign_string);
	  else if (cs_precedes && (sign_posn == 3 || sign_posn == 4))
	    left_bytes += strlen (sign_string);

	  if (other_sign_posn == 0 && !is_negative)
	    ++other_left_bytes;
	  else if (other_sign_posn == 1)
	    other_left_bytes += strlen (other_sign_string);
	  else if (other_cs_precedes &&
		   (other_sign_posn == 3 || other_sign_posn == 4))
	    other_left_bytes += strlen (other_sign_string);

	  /* Compare the number of bytes preceding the value for
	     each format, and set the padding accordingly */
	  if (other_left_bytes > left_bytes)
	    left_pad = other_left_bytes - left_bytes;
	  else
	    left_pad = 0;
	}

      /* Perhaps we'll someday make these things configurable so
	 better start using symbolic names now.  */
#define left_paren '('
#define right_paren ')'

      startp = dest;		/* Remember start so we can compute length.  */

      while (left_pad-- > 0)
	out_char (' ');

      if (sign_posn == 0 && is_negative)
	out_char (left_paren);

      if (cs_precedes)
	{
	  if (sign_posn != 0 && sign_posn != 2 && sign_posn != 4
	      && sign_posn != 5)
	    {
	      out_string (sign_string);
	      if (sep_by_space == 2)
		out_char (' ');
	    }

	  if (print_curr_symbol)
	    out_string (currency_symbol);

	  if (sign_posn == 4)
	    {
	      if (print_curr_symbol && sep_by_space == 2)
		out_char (space_char);
	      out_string (sign_string);
	      if (sep_by_space == 1)
		/* POSIX.2 and SUS are not clear on this case, but C99
		   says a space follows the adjacent-symbol-and-sign */
		out_char (' ');
	    }
	  else
	    if (print_curr_symbol && sep_by_space == 1)
	      out_char (space_char);
	}
      else
	if (sign_posn != 0 && sign_posn != 2 && sign_posn != 3
	    && sign_posn != 4 && sign_posn != 5)
	  out_string (sign_string);

      /* We clear the last available byte so we can find out whether
	 the numeric representation is too long.  */
      s[maxsize - 1] = '\0';

      memset (&info, '\0', sizeof (info));
      info.prec = right_prec;
      info.width = left_prec + (right_prec ? (right_prec + 1) : 0);
      info.spec = 'f';
      if (is_long_double)
            info._flags |= __PRINT_INFO_FLAG_is_long_double;
      if (group)
            info._flags |= __PRINT_INFO_FLAG_group;
      info.pad = pad;

      ptr = &fpnum;
      done = __printf_fp (dest, &info, fpnum, extra_char);
      if (done < 0)
	return -1;

      if (s[maxsize - 1] != '\0')
	{
	  __set_errno (E2BIG);
	  return -1;
	}

      dest += done;

      if (!cs_precedes)
	{
	  if (sign_posn == 3)
	    {
	      if (sep_by_space == 1)
		out_char (' ');
	      out_string (sign_string);
	    }

	  if (print_curr_symbol)
	    {
	      if ((sign_posn == 3 && sep_by_space == 2)
		  || (sign_posn == 4 && sep_by_space == 1)
		  || (sign_posn == 2 && sep_by_space == 1)
		  || (sign_posn == 1 && sep_by_space == 1)
		  || (sign_posn == 0 && sep_by_space == 1))
		out_char (space_char);
	      out_nstring (currency_symbol, currency_symbol_len);
	    }

	  if (sign_posn == 4)
	    {
	      if (sep_by_space == 2)
		out_char (' ');
	      out_string (sign_string);
	    }
	}

      if (sign_posn == 2)
	{
	  if (sep_by_space == 2)
	    out_char (' ');
	  out_string (sign_string);
	}

      if (sign_posn == 0 && is_negative)
	out_char (right_paren);

      /* Now test whether the output width is filled.  */
      if (dest - startp < width)
	{
	  if (left)
	    /* We simply have to fill using spaces.  */
	    do
	      out_char (' ');
	    while (dest - startp < width);
	  else
	    {
	      long int dist = width - (dest - startp);
	      for (char *cp = dest - 1; cp >= startp; --cp)
		cp[dist] = cp[0];

	      dest += dist;

	      do
		startp[--dist] = ' ';
	      while (dist > 0);
	    }
	}
    }

  /* Terminate the string.  */
  *dest = '\0';

#ifndef __LOCALE_C_ONLY
/*
 * FIXME: Restore LC_NUMERIC locale to the original one.
 */
  ls = setlocale(LC_NUMERIC, num_locale);
  if (ls == NULL) {
     fprintf (stderr, "setlocale(LC_NUMERIC, \"%s\"): %m\n", num_locale);
     return (1);
  }
#endif

  return dest - s;
}

ssize_t
__XL_NPP(strfmon) (char *s, size_t maxsize __LOCALE_PARAM, const char *format, ...)
{
  va_list ap;

  va_start (ap, format);

  ssize_t res = __vstrfmon_l (s, maxsize __LOCALE_ARG, format, ap);

  va_end (ap);

  return res;
}
