/*
 * Copyright (c) 2011  STMicroelectronics Ltd
 * Author: Filippo Arcidiacono (filippo.arcidiacono@st.com)
 *
 * Licensed under the LGPL v2.1, see the file COPYING.LIB in this tarball.
 *
 * Utility routines to get the locale name.
 *
 */

static unsigned const char *find_at(char c)
{
	const unsigned char *q;

	q = LOCALE_AT_MODIFIERS;
	do {
		if (q[1] == c) {
			return (unsigned const char *) q + 2;
		}
		q += 2 + *q;
	} while (*q);

	return NULL;
}

static void find_locale_string(locale_entry * loc_rec, char *loc)
{
	char at = 0;
	unsigned char idx;
	uint16_t dotcs, cs;

	idx = loc_rec->idx_name;
	if (!idx) {
		*loc++ = 'C';	/* jump the first locale (C) */
		*loc = '\0';
	} else {
		dotcs = (uint16_t) loc_rec->dot_cs;
		cs = (uint16_t) loc_rec->cs;;
		loc = strncpy(loc, GET_LOCALE_NAME(idx), 5);

		if (loc[2] == '_') {
			sprintf(loc, "%5.5s%c%s\0", loc, (dotcs != 0) ? '.'
				: ' ', (cs == 1) ? ascii : ((cs == 2) ?
				utf8 : GET_CODESET_NAME(cs)));
		} else {
			at = loc[2];
			loc[2] = '_';
			sprintf(loc, "%5.5s%c%s@%s\0", loc, (dotcs != 0) ? '.'
				: ' ', (cs == 1) ? ascii : ((cs == 2) ?
				utf8 : GET_CODESET_NAME(cs)), find_at(at));
		}
	}
}
