#include <linux/delay.h>
#include "dvlled_mod.h"

#include <asm/mach-atheros/atheros.h>

struct dvlled_entry global_leds[] = 
{
	//everything below: temporarily for wasp board bring-up
	{ LEDNAME_WIFI_5G,             TYPE_LED,	11,  0, POL_LA },       // LED Wifi blue
	{ LEDNAME_WIFI_2G,             TYPE_LED,	12,  0, POL_LA },       // LED Wifi green
	{ GPIONAME_DLAN_POWER,         TYPE_LED,	13,  0, POL_HA },       // PLC Chip Power
	{ LEDNAME_ETH_LINK_ACT,        TYPE_LED,	14,  0, POL_LA },       // LED Eth green
	{ LEDNAME_POWER,               TYPE_LED,	16,  0, POL_LA },       // LED Power green
	{ LEDNAME_DLAN_LEDS_ENABLE,    TYPE_LED,	17,  0, POL_HA },       // Both PLC LEDs on/off
	{ LEDNAME_LNA_A,               TYPE_LED,	18,  0, POL_HA },       // Switch WiFi LNA
	{ LEDNAME_LNA_B,               TYPE_LED,	19,  0, POL_HA },       // Switch WIFi LNA

#if 0
	{ LEDNAME_DLAN_SLEEP,       	TYPE_LED,  		-1, -1, POL_HA },
#endif
	
	{ "", TYPE_NONE, 0, 0, 0 }
};

int lan_led_idx = 3; //index of the gpio entry in the global_leds array that represents the lan activity led
int wireless_2g_led_idx = 1; //index of the gpio entry in the global_leds array that represents the wireless 2g activity led
int wireless_5g_led_idx = 0; //index of the gpio entry in the global_leds array that represents the wireless 5g activity led

#define GPIO_DIR_OUT 0
#define GPIO_DIR_IN  1

#define REG_GPIO_OE            ATH_GPIO_OE
#define REG_GPIO_IN            ATH_GPIO_IN
#define REG_GPIO_OUT           ATH_GPIO_OUT
#define REG_GPIO_SET           ATH_GPIO_SET
#define REG_GPIO_CLEAR         ATH_GPIO_CLEAR
#define REG_GPIO_INT           ATH_GPIO_INT_ENABLE
#define REG_GPIO_INT_TYPE      ATH_GPIO_INT_TYPE
#define REG_GPIO_INT_POLARITY  ATH_GPIO_INT_POLARITY
#define REG_GPIO_INT_PENDING   ATH_GPIO_INT_PENDING
#define REG_GPIO_INT_MASK      ATH_GPIO_INT_MASK
#define REG_GPIO_OUT_FUNC4     ATH_GPIO_OUT_FUNCTION4

static int gpio_func_unmapped = 0;

static void dvl_gpio_line_config(int line, int direction)
{
	uint32_t tmp, tmp2;

	if (gpio_func_unmapped == 0 && line == 16)
    {
        //disable the per default mapped undocumented function of gpio16,
        //that is preventing us from toggling the gpio.
        printk("### unmapping function for gpio 16\n");
        tmp = ath_reg_rd(REG_GPIO_OUT_FUNC4);
        tmp &= 0xFFFFFF00;
        ath_reg_wr(REG_GPIO_OUT_FUNC4, tmp);

        gpio_func_unmapped = 1;
    }

	// direction
	tmp = ath_reg_rd(REG_GPIO_OE);
	if (direction == GPIO_DIR_OUT)
		tmp &= ~(uint32_t)(1 << line);
	else if (direction == GPIO_DIR_IN)
		tmp |= (uint32_t)(1 << line);

	printk("# configuring gpio %d as output\n", line);
	ath_reg_wr(REG_GPIO_OE, tmp);
}

static void dvl_gpio_line_set(int line, int value)
{
	uint32_t tmp = 0;

	if (value)
	{
		ath_reg_wr(REG_GPIO_SET, (uint32_t)(1 << line));
	}
	else
	{
		ath_reg_wr(REG_GPIO_CLEAR, (uint32_t)(1 << line));
	}
}

//
//
//

void dvl_led_config_out(int line)
{
	dvl_gpio_line_config(line, GPIO_DIR_OUT);
}

void dvl_led_set(int line, int value)
{
	dvl_gpio_line_set(line, value);
}

void dvl_led_probe(struct platform_device *pdev)
{
}

void dvl_led_remove(struct platform_device *pdev)
{
}

void dvl_led_init(void)
{
}

