#include "disableHeartbeat.h"

static struct system_load_container currentSystemLoad;
static struct system_load_container oldSystemLoad;


static void clearSystemLoadContainer(struct system_load_container *container);
static u64 getSumLoad(struct system_load_container *container);
static unsigned char getSoftirqRelation(struct system_load_container *_old, struct system_load_container *_current);
static void update_system_load(void);
static int shouldWatchdogDisabledByLoad(void);

#if 0
static void printSystemLoadContainer(struct system_load_container *container)
{
	printk("cpu  %llu %llu %llu %llu %llu %llu %llu %llu %llu %llu\n",
		(unsigned long long)cputime64_to_clock_t(container->user),
		(unsigned long long)cputime64_to_clock_t(container->nice),
		(unsigned long long)cputime64_to_clock_t(container->system),
		(unsigned long long)cputime64_to_clock_t(container->idle),
		(unsigned long long)cputime64_to_clock_t(container->iowait),
		(unsigned long long)cputime64_to_clock_t(container->irq),
		(unsigned long long)cputime64_to_clock_t(container->softirq),
		(unsigned long long)cputime64_to_clock_t(container->steal),
		(unsigned long long)cputime64_to_clock_t(container->guest),
		(unsigned long long)cputime64_to_clock_t(container->guest_nice));
}
#endif

static void clearSystemLoadContainer(struct system_load_container *container)
{
    memset(container,0,sizeof(struct system_load_container));
}

static u64 getSumLoad(struct system_load_container *container)
{
    return  
        container->user + container->nice + 
        container->system + container->idle +
        container->iowait + container->irq +
        container->softirq + container->steal + 
        container->guest + container->guest_nice;
}

static unsigned char getSoftirqRelation(struct system_load_container *_old, struct system_load_container *_current)
{
    unsigned int deltaSoftirq = (unsigned int)(_current->softirq - _old->softirq);
    unsigned int deltaSumLoad = (unsigned int)(getSumLoad(_current) - getSumLoad(_old));
    return (unsigned char)((deltaSoftirq*100)/deltaSumLoad);
}


static void update_system_load(void)
{
	int i, j;
    
    oldSystemLoad = currentSystemLoad; //backup
    clearSystemLoadContainer(&currentSystemLoad);

    //fillNew
	for_each_possible_cpu(i) {
		currentSystemLoad.user += kcpustat_cpu(i).cpustat[CPUTIME_USER];
		currentSystemLoad.nice += kcpustat_cpu(i).cpustat[CPUTIME_NICE];
		currentSystemLoad.system += kcpustat_cpu(i).cpustat[CPUTIME_SYSTEM];
		currentSystemLoad.idle += get_idle_time(i);
		currentSystemLoad.iowait += get_iowait_time(i);
		currentSystemLoad.irq += kcpustat_cpu(i).cpustat[CPUTIME_IRQ];
		currentSystemLoad.softirq += kcpustat_cpu(i).cpustat[CPUTIME_SOFTIRQ];
		currentSystemLoad.steal += kcpustat_cpu(i).cpustat[CPUTIME_STEAL];
		currentSystemLoad.guest += kcpustat_cpu(i).cpustat[CPUTIME_GUEST];
		currentSystemLoad.guest_nice += kcpustat_cpu(i).cpustat[CPUTIME_GUEST_NICE];
		currentSystemLoad.sum_irq += kstat_cpu_irqs_sum(i);
		currentSystemLoad.sum_irq += arch_irq_stat_cpu(i);

		for (j = 0; j < NR_SOFTIRQS; j++) {
			unsigned int softirq_stat = kstat_softirqs_cpu(j, i);
			currentSystemLoad.sum_softirq += softirq_stat;
		}
	}
}

static int disableWatchdogHistory[2] = {0}; //internal use only

#ifdef _DVL_DISABLE_WATCHDOG_BY_LOAD
static int shouldWatchdogDisabledByLoad(void)
{
    disableWatchdogHistory[0] = disableWatchdogHistory[1]; 

    update_system_load();
    if (getSoftirqRelation(&oldSystemLoad,&currentSystemLoad) > _DVL_DISABLE_WATCHDOG_BY_LOAD)
        return disableWatchdogHistory[1] = 1;
    return  disableWatchdogHistory[1] = 0;
}
#endif



// USER INTERFACES
int shouldWatchdogDisabled(void)
{
    //for future: combine different disable conditions here: disable by load, disably by traffic etc.
#ifdef _DVL_DISABLE_WATCHDOG_BY_LOAD
    return shouldWatchdogDisabledByLoad();
#else
    return 0;
#endif
}
EXPORT_SYMBOL(shouldWatchdogDisabled);

int disableWatchdogStatusChange(void)
{
    return !!(disableWatchdogHistory[0] ^ disableWatchdogHistory[1]); //xor
}
EXPORT_SYMBOL(disableWatchdogStatusChange);
