/**********************************************************************
 *
 * Filename:    memtest.h
 * 
 * Description: Memory-testing module API.
 *
 * Notes:       The memory tests can be easily ported to systems with
 *              different data bus widths by redefining 'datum_t' type.
 *
 * 
 * Copyright (c) 2000 by Michael Barr.  This software is placed into
 * the public domain and may be used for any purpose.  However, this
 * notice must not be changed or removed and no warranty is either
 * expressed or implied by its publication or distribution.
 *
 * Modified by Daniel Freund, devolo AG Aachen, Germany in 2011
 **********************************************************************/

#ifndef _memtest_h
#define _memtest_h

#define REG_GPIO_IN						    0x18040004	//where to find the current gpio input values
#ifndef BUILD_FOR_DEVOLO_HW_DESIGN
    #define GPIO_ABORT_MEMTEST		        (1 << 16)	//use jumpstart gpio on reference design to abort memtest
    #define GPIO_ABORT_MEMTEST_ACTIVE_STATE	0   		//which value the gpio has when active
#else
    #define GPIO_ABORT_MEMTEST			    (1 << 4)	//which bit/gpio line to check for activation
    #define GPIO_ABORT_MEMTEST_ACTIVE_STATE	0	    	//which value the gpio has when active
#endif


/*
 * Set the data bus width.
 */
typedef unsigned long datum_t;

/*
 * Function prototypes.
 */
int check_for_abort(void);
int run_memtest(datum_t* baseAddress, int numBytes);
int memTestDataBus(volatile datum_t * address);
int memTestAddressBus(volatile datum_t * baseAddress, unsigned long nBytes);
int memTestDevice(volatile datum_t * baseAddress, unsigned long nBytes);


#endif /* _memtest_h */

