/*
 * Copyright (c) 2013 Qualcomm Atheros, Inc.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <command.h>
#include <asm/mipsregs.h>
#include <asm/addrspace.h>
#include <config.h>
#include <version.h>
#include "ar7240_soc.h"

#ifdef CONFIG_ATH_NAND_BR
#include <nand.h>
#endif

extern int wasp_ddr_initial_config(uint32_t refresh);
extern int ar7240_ddr_find_size(void);

#ifdef COMPRESSED_UBOOT
#	define prmsg(...)
#	define args		char *s
#	define board_str(a)	do {			\
	char ver[] = "0";				\
	strcpy(s, "U-Boot " a "Wasp 1.");		\
	ver[0] += ar7240_reg_rd(AR7240_REV_ID) & 0xf;	\
	strcat(s, ver);					\
} while (0)
#else
#	define prmsg		printf
#	define args		void
#	define board_str(a)	printf(a)
#endif

void
wasp_usb_initial_config(void)
{
#define unset(a)	(~(a))

	if ((ar7240_reg_rd(WASP_BOOTSTRAP_REG) & WASP_REF_CLK_25) == 0) {
		ar7240_reg_wr_nf(AR934X_SWITCH_CLOCK_SPARE,
			ar7240_reg_rd(AR934X_SWITCH_CLOCK_SPARE) |
			SWITCH_CLOCK_SPARE_USB_REFCLK_FREQ_SEL_SET(2));
	} else {
		ar7240_reg_wr_nf(AR934X_SWITCH_CLOCK_SPARE,
			ar7240_reg_rd(AR934X_SWITCH_CLOCK_SPARE) |
			SWITCH_CLOCK_SPARE_USB_REFCLK_FREQ_SEL_SET(5));
	}

	udelay(1000);
	ar7240_reg_wr(AR7240_RESET,
		ar7240_reg_rd(AR7240_RESET) |
		RST_RESET_USB_PHY_SUSPEND_OVERRIDE_SET(1));
	udelay(1000);
	ar7240_reg_wr(AR7240_RESET,
		ar7240_reg_rd(AR7240_RESET) &
		unset(RST_RESET_USB_PHY_RESET_SET(1)));
	udelay(1000);
	ar7240_reg_wr(AR7240_RESET,
		ar7240_reg_rd(AR7240_RESET) &
		unset(RST_RESET_USB_PHY_ARESET_SET(1)));
	udelay(1000);
	ar7240_reg_wr(AR7240_RESET,
		ar7240_reg_rd(AR7240_RESET) &
		unset(RST_RESET_USB_HOST_RESET_SET(1)));
	udelay(1000);
	if ((ar7240_reg_rd(AR7240_REV_ID) & 0xf) == 0) {
		/* Only for WASP 1.0 */
		ar7240_reg_wr(0xb8116c84 ,
			ar7240_reg_rd(0xb8116c84) & unset(1<<20));
	}
}

void wasp_gpio_config(void)
{
    printf("dvl: configure GPIOs:\n");
//can be configured in config.AR934X/config.zuse
#ifdef BUILD_FOR_DEVOLO_HW_DESIGN
    int gpio_inout_map, gpio_low_map, gpio_high_map, temp;

#if 1   //set output value of gpios to define a valid environment
        //Importent Note: Set values before direction, these are the inital values
	gpio_low_map  = 0x0; //map of all gpios set to low state (does not necessarily mean off!)
	gpio_high_map = 0x0; //map of all gpios set to high state (does not necessarily mean on!)
	gpio_high_map |= (1 << 12); //led wifi white, active low
	gpio_low_map  |= (1 << 13); //plc power enable, active high
	gpio_high_map |= (1 << 14); //led plc white, active low
	gpio_high_map |= (1 << 15); //led plc red, active high
	gpio_high_map |= (1 << 21); //wifi ac (Perigrine) enable, active high
	printf("setting output gpio states (set 0x%08x, clear 0x%08x)\n", gpio_low_map, gpio_high_map);
	ar7240_reg_wr(AR7240_GPIO_SET, gpio_high_map);
	ar7240_reg_wr(AR7240_GPIO_CLEAR, gpio_low_map);
#endif

#if 1 //define input and output considering to devolo hardware design
	printf("set gpio direction (in/out)\n");
	printf("  previous setting was: 0x%08x\n", ar7240_reg_rd(AR7240_GPIO_OE));
	gpio_inout_map = 0x0; //this would set all gpios as output
	gpio_inout_map |= (1 << 4);  //set gpio 4 as input for reset button
	gpio_inout_map |= (1 << 8);  //set gpio 8 as input for spi data
	gpio_inout_map |= (1 << 9);  //set gpio 9 as input for uart0 data
    gpio_inout_map |= (1 << 11); //set gpio 16 (gpio_plc0) needs to be high before every powerup/reset. It straps the QCA7500, so use it as input (7500 gpio1)
	gpio_inout_map |= (1 << 16); //set gpio 16 (gpio_plc1) as input for Wasp/7500 communication (7500 gpio8)
	gpio_inout_map |= (1 << 17); //set gpio 17 (gpio_plc2) as input for Wasp/7500 communication (7500 gpio10)
                                 //set gpio 18 & gpio 19 to output (VLNA bias)
	gpio_inout_map |= (1 << 20); //set gpio 20 as input for wifi button
	gpio_inout_map |= (1 << 22); //set gpio 22 as input for pairing button
	printf("  new setting will be: 0x%08x\n", gpio_inout_map);
	ar7240_reg_wr(AR7240_GPIO_OE, gpio_inout_map); //set desired in/out settings
/*
 *      Wasp          <->       QCA7500
 * gpio11 (gpio_plc0) <-> (GPIO1_CON)  gpio1
 * gpio16 (gpio_plc1) <-> (GPIO8_CON)  gpio8
 * gpio17 (gpio_plc2) <-> (GPIO10_CON) gpio10
 */
#endif

#if 1 //define functional behavior for out gpios
	printf("setting gpio OUT function mappings\n");
	ar7240_reg_wr(AR7240_GPIO_OUT_FUNCTION0, 0x00000000);
	ar7240_reg_wr(AR7240_GPIO_OUT_FUNCTION1, 0x0b0a0900); //set gpio 5 to spi_cs_0, 6 to spi_clk and 7 to spi_mosi
	ar7240_reg_wr(AR7240_GPIO_OUT_FUNCTION2, 0x00180000); //set gpio 10 to uart0_sout
	ar7240_reg_wr(AR7240_GPIO_OUT_FUNCTION3, 0x00000000);
	ar7240_reg_wr(AR7240_GPIO_OUT_FUNCTION4, 0x2f2e0000); //set gpio 18 and 19 to lna control
	temp = ar7240_reg_rd(AR7240_GPIO_OUT_FUNCTION5);
	temp &= 0xFF000000; //clear function mapping for gpios 20, 21 and 22
	ar7240_reg_wr(AR7240_GPIO_OUT_FUNCTION5, temp);
#endif

#if 1 //define functional behavior for in gpios
	printf("setting gpio IN function mappings\n");
	ar7240_reg_wr(AR7240_GPIO_IN_ENABLE0, 0x00000908); //set gpio 9 to uart0_sin and gpio 8 to spi_miso (do it although it's the default)
	ar7240_reg_wr(AR7240_GPIO_IN_ENABLE1, 0x00000000);
	ar7240_reg_wr(AR7240_GPIO_IN_ENABLE2, 0x00000000);
	ar7240_reg_wr(AR7240_GPIO_IN_ENABLE3, 0x00000000);
	ar7240_reg_wr(AR7240_GPIO_IN_ENABLE4, 0x00000000);
	ar7240_reg_wr(AR7240_GPIO_IN_ENABLE9, 0x00000000);
#endif

#if 1 //define gpio interrupt behaviour => off
	printf("clearing and disabling all gpio interrupts\n");
	(void) ar7240_reg_rd(AR7240_GPIO_INT_PENDING);
	ar7240_reg_wr(AR7240_GPIO_INT_PENDING, 0);
	ar7240_reg_wr(AR7240_GPIO_INT_ENABLE, 0);
	ar7240_reg_wr(AR7240_GPIO_INT_MASK, 0);
#endif
#else
    printf("    nothing to do.\n");
#endif


#if 0 //old atheros pattern
	/* disable the CLK_OBS on GPIO_4 and set GPIO4 as input */
	ar7240_reg_rmw_clear(GPIO_OE_ADDRESS, (1 << 4));
	ar7240_reg_rmw_clear(GPIO_OUT_FUNCTION1_ADDRESS, GPIO_OUT_FUNCTION1_ENABLE_GPIO_4_MASK);
	ar7240_reg_rmw_set(GPIO_OUT_FUNCTION1_ADDRESS, GPIO_OUT_FUNCTION1_ENABLE_GPIO_4_SET(0x80));
	ar7240_reg_rmw_set(GPIO_OE_ADDRESS, (1 << 4));
#endif
}

int
wasp_mem_config(void)
{
	extern void ath_ddr_tap_cal(void);
	unsigned int type, reg32;

	type = wasp_ddr_initial_config(CFG_DDR_REFRESH_VAL);

	ath_ddr_tap_cal();

	prmsg("Tap value selected = 0x%x [0x%x - 0x%x]\n",
		ar7240_reg_rd(AR7240_DDR_TAP_CONTROL0),
		ar7240_reg_rd(0xbd007f10), ar7240_reg_rd(0xbd007f14));

	/* Take WMAC out of reset */
	reg32 = ar7240_reg_rd(AR7240_RESET);
	reg32 = reg32 &  ~AR7240_RESET_WMAC;
	ar7240_reg_wr_nf(AR7240_RESET, reg32);

#if !defined(CONFIG_ATH_NAND_BR)
	/* Switching regulator settings */
	ar7240_reg_wr_nf(0x18116c40, 0x633c8176); /* AR_PHY_PMU1 */
	ar7240_reg_wr_nf(0x18116c44, 0x10380000); /* AR_PHY_PMU2 */

	wasp_usb_initial_config();

#endif /* !defined(CONFIG_ATH_NAND_BR) */

	wasp_gpio_config();

	reg32 = ar7240_ddr_find_size();

	return reg32;
}

long int initdram(int board_type)
{
	return (wasp_mem_config());
}

int	checkboard(args)
{
#if CONFIG_AP123
	board_str("AP123\n");
#elif CONFIG_MI124
	board_str("MI124\n");
#elif CONFIG_CUS227
	board_str("CUS227\n");
#else
	board_str("DB120\n");
#endif
	return 0;
}

#if defined(CONFIG_HW_WATCHDOG)
void hw_watchdog_reset(void)
{
	ar7240_reg_wr(AR7240_WATCHDOG_TMR, 0xffffffff);
}
#endif
